//----------------------------------------------------------------------------//
//- CadAnbieterUebersicht.pas ------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Zeigt eine bersicht aller Anbieter an.                                    //
// Es besteht die Mglichkeit, Anbieter zu bearbeiten, zu lschen oder        //
// neue zu erstellen                                                          //
// -> Abgeleitet von CadBaseDialog                                            //
//----------------------------------------------------------------------------//

unit CadAnbieterUebersicht;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, ExtCtrls, CafAnbieterUebersicht,
  CaoPersonenListe;

//------------------------------------------------------------------------------

type
  TCaDlgAnbieterUebersicht = class(TCaDlgBaseDialog)
    m_FrmAnbieterUebersicht: TFrmAnbieterUebersicht;
    m_PanSeparator         : TPanel;
    m_BtnNeu               : TButton;
    m_BtnKopieren          : TButton;
    m_BtnBearbeiten        : TButton;
    m_BtnLoeschen          : TButton;

    //--------------------------------------------------------------------------

    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

  //----------------------------------------------------------------------------

  private
    m_obAnbieterListe: TCaoPersonenListe;
    m_iModus         : Integer;

  //----------------------------------------------------------------------------

  protected

  //----------------------------------------------------------------------------

  public
    function ShowModal(iModus: Integer; obAnbieterListe: TCaoPersonenListe)
                                               : Integer; reintroduce; overload;

  //----------------------------------------------------------------------------

  end; // TCaDlgAnbieterUebersicht

//------------------------------------------------------------------------------

var
  CaDlgAnbieterUebersicht: TCaDlgAnbieterUebersicht;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst, CadAnbieter;

//------------------------------------------------------------------------------

function TCaDlgAnbieterUebersicht.ShowModal(iModus: Integer;
                                   obAnbieterListe: TCaoPersonenListe): Integer;
var
  iAnbieterResult: Integer; 
begin
  m_obAnbieterListe := obAnbieterListe;
  iAnbieterResult   := c_iKeineAngabe;
  m_iModus          := iModus;

  // Wurde der Anbieterdialog mit "Abbrechen" verlassen, so soll die Anbieter-
  // bersicht nicht gestartet werden.
  if iAnbieterResult <> mrCancel then begin
    Result := inherited ShowModal;
  end // if
  else begin
    Result := mrCancel;
  end; // else
end; // TCaDlgAnbieterUebersicht.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgAnbieterUebersicht.FormShow(Sender: TObject);
begin
  m_FrmAnbieterUebersicht.ShowFrame(Self.Handle, m_obAnbieterListe);
  inherited;
  // Ist m_iModus = c_iModusNeu dann soll ein neuer Anbieter erfasst werden.
  // -> Es wird der Anbieterdialog gestartet
  if m_iModus = c_iModusNeu then begin
    m_FrmAnbieterUebersicht.ActNeuExecute(Self);
  end; // if
end; // TCaDlgAnbieterUebersicht.FormShow

//------------------------------------------------------------------------------ 

procedure TCaDlgAnbieterUebersicht.FormCreate(Sender: TObject);
begin
  inherited;
  m_FrmAnbieterUebersicht.CreateFrame(m_obAnbieterListe);
end; //  TCaDlgAnbieterUebersicht.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgAnbieterUebersicht.FormDestroy(Sender: TObject);
begin
  m_FrmAnbieterUebersicht.DestroyFrame;
  inherited;
end; // TCaDlgAnbieterUebersicht.FormDestroy

//------------------------------------------------------------------------------

end. // CadAnbieterUebersicht
